// Fraction_bar_widget.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_APP_FRACTION_BAR_WIDGET_HPP_
#define ROAN_TRAIL_KINETOPHONE_APP_FRACTION_BAR_WIDGET_HPP_

#include <gtkmm/widget.h>
#include <kinetophone/View.hpp>

namespace Gdk
{
  class Color;
  class Rectangle;
}

namespace Glib
{
  template <class T> class RefPtr;
}

namespace Gtk
{
  class Widget;
}

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Error_param;
  }

  namespace Kinetophone_app
  {
    class Fraction_bar_widget : public Roan_trail::Kinetophone::View, public Gtk::Widget
    {
    public:
      // constructor/destructor
      explicit Fraction_bar_widget(bool enabled,
                                   bool vertical = false,
                                   double fraction = -1.0,
                                   double warning_fraction = -1.0,
                                   double critical_fraction = -1.0,
                                   double empty_fraction = -1.0,
                                   int bar_thickness = -1,
                                   int bar_width = -1,
                                   int border_padding = 0);
      virtual ~Fraction_bar_widget();
      // view update
      virtual bool update(Roan_trail::Kinetophone::Error_param& return_error);
      // accessors
      // mutators
      virtual void set_enabled(bool enabled);
      virtual void set_fraction(double fraction);
      virtual void set_warning_fraction(double warning_fraction);
      virtual void set_critical_fraction(double warning_fraction);
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
      // signal handlers
      virtual void on_size_request(Gtk::Requisition* return_requisition);
      virtual void on_size_allocate(Gtk::Allocation& allocation);
      virtual void on_map();
      virtual void on_unmap();
      virtual void on_realize();
      virtual void on_unrealize();
      virtual bool on_expose_event(GdkEventExpose* event);
      //
      Glib::RefPtr<Gdk::Window> m_ref_window;
    private:
      bool m_enabled;
      bool m_vertical;
      double m_fraction;
      double m_warning_fraction;
      double m_critical_fraction;
      double m_empty_fraction;
      bool m_show_warning;
      bool m_show_critical;
      bool m_show_empty;
      // rectangles
      //   cached between resize
      Gdk::Rectangle m_window_rect;
      Gdk::Rectangle m_bar_background_rect;
      //   cached when update member function is called
      Gdk::Rectangle m_bar_rect;
      // colors
      Gdk::Color m_normal_color;
      Gdk::Color m_empty_color;
      Gdk::Color m_warning_color;
      Gdk::Color m_critical_color;
      Gdk::Color m_background_color;
      Gdk::Color m_disabled_color;
      //
      const int m_bar_thickness;
      const int m_bar_length;
      const int m_border_padding;
      //
      bool m_widget_sized;
      //
      void mf_calc_widget_size(int& return_height, int& return_width);
      void mf_calc_fixed_rects(const Gdk::Rectangle& rect);
      void mf_update_bar();
      void mf_setup_colors();
      // prevent compiler from generating
      Fraction_bar_widget(const Fraction_bar_widget& fraction_bar);
      Fraction_bar_widget& operator=(const Fraction_bar_widget& fraction_bar);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_APP_FRACTION_BAR_WIDGET_HPP_
