// Option_checks.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

// Functions for checking program option validity

#ifndef ROAN_TRAIL_KINETOPHONE_OPTION_CHECKS_HPP_
#define ROAN_TRAIL_KINETOPHONE_OPTION_CHECKS_HPP_

#include <boost/program_options.hpp>

namespace Roan_trail
{
  namespace Kinetophone
  {
    //
    // Free functions
    //

    //   Function used to check that 'opt1' and 'opt2' are not specified
    //   at the same time.
    void check_conflicting_options(const boost::program_options::variables_map& VM,
                                   const char* opt1,
                                   const char* opt2,
                                   bool condition = true,
                                   const std::string& message = "");

    //   Function used to check that 'for_what' is specified, then
    //   'required_option' is specified too.
    void check_option_dependency(const boost::program_options::variables_map& VM,
                                 const char* for_what,
                                 const char* required_option,
                                 bool condition = true);
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_OPTION_CHECKS_HPP_
