// Option_checks.cpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#include <kinetophone/option_checks.hpp>
#include <kinetophone/common.hpp>
#include <boost/program_options.hpp>
#include <exception>
#include <string>

using std::logic_error;
using std::string;
using boost::program_options::variables_map;

void Roan_trail::Kinetophone::check_conflicting_options(const variables_map& VM,
                                                        const char* opt1,
                                                        const char* opt2,
                                                        bool condition,
                                                        const string& message)
{
  precondition(opt1
               && opt2);

  if (condition &&
      (VM.count(opt1) && !VM[opt1].defaulted()
       && VM.count(opt2) && !VM[opt2].defaulted()))
  {
    string exception_message = string("conflicting options '")
      + opt1 + "' and '" + opt2 + "'";
    if ("" != message)
    {
      exception_message += string(": ") + message;
    }
    exception_message += ".";
    throw logic_error(exception_message);
  }
}

void Roan_trail::Kinetophone::check_option_dependency(const variables_map& VM,
                                                      const char* for_what,
                                                      const char* required_option,
                                                      bool condition)
{
  precondition(for_what
               && required_option);

  if (VM.count(for_what) && !VM[for_what].defaulted())
  {
    if ((VM.count(required_option) == 0)
        || VM[required_option].defaulted()
        || !condition)
    {
      throw logic_error(string("option '") + for_what
                        + "' requires option '" + required_option + "'.");
    }
  }
}

