// Posix_error.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_POSIX_ERROR_HPP_
#define ROAN_TRAIL_KINETOPHONE_POSIX_ERROR_HPP_

#include <kinetophone/error/Error.hpp>
#include <string>

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Posix_error : public Error
    {
    public:
      // constructor/destructor/copy
      Posix_error(int posix_code,
                  const char* posix_function_name,
                  const char* file_path,
                  const Error* base_error = 0);
      virtual Posix_error* clone() const { return new Posix_error(*this); }
      // other
      virtual std::string error_class() const { return "Posix_error"; }
      static const int error_return;
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      // prevent compiler from generating
      Posix_error& operator=(const Posix_error& e);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_POSIX_ERROR_HPP_
