// Portaudio_error.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_PORTAUDIO_ERROR_HPP_
#define ROAN_TRAIL_KINETOPHONE_PORTAUDIO_ERROR_HPP_

#include <kinetophone/error/Error.hpp>
#include <string>

typedef int PaError;

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Portaudio_error : public Error
    {
    public:
      // constructor/destructor/copy
      Portaudio_error(PaError code,
                      const char* portaudio_function_name,
                      const Error* base_error = 0);
      virtual Portaudio_error* clone() const { return new Portaudio_error(*this); }
      // other
      virtual std::string error_class() const { return "Portaudio_error"; }
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      // prevent compiler from generating
      Portaudio_error operator=(const Portaudio_error& e);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_PORTAUDIO_ERROR_HPP_
