// Poppler_error.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

// Error class which wraps a Poppler GError (glib), takes ownership
// and frees GError pointer specified in the constructor (base_error)

#ifndef ROAN_TRAIL_KINETOPHONE_GLIB_POPPLER_ERROR_HPP_
#define ROAN_TRAIL_KINETOPHONE_GLIB_POPPLER_ERROR_HPP_

#include <kinetophone/error/Error.hpp>
#include <kinetophone/common.hpp>
#include <string>
#include <poppler.h>

namespace Roan_trail
{
  namespace Kinetophone_glib
  {
    class Poppler_error : public Roan_trail::Kinetophone::Error
    {
    public:
      // constructor/destructor/copy/clone
      Poppler_error(const char* file,
                    const char* function,
                    int line,
                    const std::string& file_path,
                    GError* base_error);
      virtual Poppler_error* clone() const { return new Poppler_error(*this); }
      // error keys
      const static std::string poppler_domain_error_key;
      // other
      virtual std::string error_class() const { return "Poppler_error"; }
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      uint32_t m_domain;
      // prevent compiler from generating
      Poppler_error operator=(const Poppler_error& e);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_GLIB_POPPLER_ERROR_HPP_
