// View.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

// Abstract base, view class
// (MVC pattern)

#ifndef ROAN_TRAIL_KINETOPHONE_VIEW_HPP_
#define ROAN_TRAIL_KINETOPHONE_VIEW_HPP_

namespace Roan_trail

{
  namespace Kinetophone
  {
    class Error_param;

    class View
    {
    public:
      virtual ~View() {}
      virtual bool update(Error_param& return_error) = 0;
    protected:
      View() {}
    private:
      // prevent compiler from generating
      View(const View& v);
      View& operator=(const View& v);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_VIEW_HPP_
