// Speech_synthesizer_config.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_SPEECH_SYNTHESIZER_CONFIG_HPP_
#define ROAN_TRAIL_KINETOPHONE_SPEECH_SYNTHESIZER_CONFIG_HPP_

#include <map>
#include <string>

// helper struct to store sound recorder settings

namespace Roan_trail
{
  namespace Kinetophone
  {
    struct Sound_file_config;

    struct Speech_synthesizer_config
    {
    public:
      // constructor/destructor/copy
      Speech_synthesizer_config();
      ~Speech_synthesizer_config();
      Speech_synthesizer_config(const Speech_synthesizer_config& c);
      Speech_synthesizer_config& operator=(const Speech_synthesizer_config& c);
      // helpers
      static std::string setup_command_for_voice(const std::string& voice);
      // structure data members
      std::string voice;
      Sound_file_config* sound_file;
      bool file_overwrite;
      // struct members
      static std::map<std::string, std::string> m_voice_setup_map;
      // struct constants
      //   default constants
      static const std::string default_voice;
      static const int default_sample_rate;
      //
      void mf_setup_maps();
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_SPEECH_SYNTHESIZER_CONFIG_HPP_
