// Speech_synthesizer_config.cpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#include <kinetophone/Speech_synthesizer_config.hpp>
#include <kinetophone/Sound_file_config.hpp>
#include <kinetophone/common.hpp>
#include <boost/algorithm/string.hpp>
#include <map>
#include <string>

using boost::algorithm::to_lower;
using std::map;
using std::string;
using namespace Roan_trail::Kinetophone;

// TODO: currently Festival is 16 bit pcm, 16K S/S (forced to wav/aiff by Kinetophone)
// TODO: make sure if this changes, some kind of error or adaptation?

//
// Constructor/destructor
//

Speech_synthesizer_config::Speech_synthesizer_config()
  // setup some reasonable defaults
  : voice(default_voice),
    sound_file(new Sound_file_config),
    file_overwrite(false)
{
  if (!m_voice_setup_map.size())
  {
    mf_setup_maps();
  }

  sound_file->sample_rate = default_sample_rate; // override sound file config's default to Festival's
}

Speech_synthesizer_config::~Speech_synthesizer_config()
{
  delete sound_file;
}

Speech_synthesizer_config::Speech_synthesizer_config(const Speech_synthesizer_config& s)
  : voice(s.voice),
    sound_file(new Sound_file_config),
    file_overwrite(s.file_overwrite)
{
  *sound_file = *s.sound_file;
}

Speech_synthesizer_config& Speech_synthesizer_config::operator=(const Speech_synthesizer_config& s)
{
  if (&s != this)
  {
    voice = s.voice;
    *sound_file = *s.sound_file;
    file_overwrite = s.file_overwrite;
  }

  return *this;
}

//
// Helpers
//

string Speech_synthesizer_config::setup_command_for_voice(const string& voice)
{
  string return_value = "";
  string lower_voice = voice;
  to_lower(lower_voice);

  map<string, string>::const_iterator p = m_voice_setup_map.find(lower_voice);
  if (p != m_voice_setup_map.end())
  {
    return_value = p->second;
  }

  return return_value;
}

//
// Class members
//

map<string, string> Speech_synthesizer_config::m_voice_setup_map;

//
// Class constants
//

// default constants
const string Speech_synthesizer_config::default_voice = "";
const int Speech_synthesizer_config::default_sample_rate = 48000; // Festival's default sample rate

// Private member functions

void Speech_synthesizer_config::mf_setup_maps()
{
  m_voice_setup_map["en_br_m"] = "(voice_rab_diphone)"; // British English male
  m_voice_setup_map["en_us_m"] = "(voice_kal_diphone)"; // American English male
  m_voice_setup_map["en_us_m_alt"] = "(voice_ked_diphone)"; // American English male (alternate)
  m_voice_setup_map["it_m"] = "(voice_pc_diphone)"; // Italian male
  m_voice_setup_map["it_f"] = "(voice_lp_diphone)"; // Italian female
  m_voice_setup_map["es_m"] = "(voice_el_diphone)"; // Spanish male
}
