//  Segment.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_SEGMENT_HPP_
#define ROAN_TRAIL_KINETOPHONE_SEGMENT_HPP_

#include <kinetophone/common.hpp>

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Segment {
    public:
      Segment(Long_int index,
              Long_int start_frame,
              Long_int end_frame,
              Long_int ordinality,
              bool is_retake);
      // accessors
      Long_int index() const { return m_index; }
      Long_int start_frame() const { return m_start_frame; }
      Long_int end_frame() const { return m_end_frame; }
      Long_int frame_count() const { return m_frame_count; }
      Long_int ordinality() const { return m_ordinality; } // original segment number
      bool is_retake() const { return m_is_retake; }
    private:
      Long_int m_index;
      Long_int m_start_frame;
      Long_int m_end_frame;
      Long_int m_frame_count;
      Long_int m_ordinality; // original segment number
      bool m_is_retake;
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_SEGMENT_HPP_
