//  Segment.cpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#include <kinetophone/Segment.hpp>
#include <kinetophone/error/Error.hpp>

using namespace Roan_trail::Kinetophone;

Segment::Segment(Long_int index,
                 Long_int start_frame,
                 Long_int end_frame,
                 Long_int ordinality,
                 bool is_retake)
  : m_index(index),
    m_start_frame(start_frame),
    m_end_frame(end_frame),
    m_frame_count(end_frame - start_frame + 1),
    m_ordinality(ordinality),
    m_is_retake(is_retake)
{
  precondition(start_frame <= end_frame
               && "error, start frame is greater than end frame");
}

