// Recorder.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_RECORDER_HPP_
#define ROAN_TRAIL_KINETOPHONE_RECORDER_HPP_

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Recorder
    {
    public:
      Recorder() : m_state(state_stopped) {};
      virtual ~Recorder() {}
      // accessors
      int state() const { return m_state; }
      // control
      void record(); // sets state from stopped -> recording or from paused -> recording
      void pause(); // sets state from recording -> paused
      void stop(); // set state from recording -> stopped or from paused -> stopped
      // state constants
      static const int state_stopped   = 0;
      static const int state_paused    = 1;
      static const int state_recording = 2;
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      int m_state;
      // prevent compiler from generating
      Recorder(const Recorder& r);
      Recorder& operator=(const Recorder& r);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_RECORDER_HPP_
