// Poppler_compat.hpp
//
// Copyright 2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

// Compatibility class for Poppler PDF rendering library, using GLib

#ifndef ROAN_TRAIL_KINETOPHONE_GLIB_POPPLER_COMPAT_HPP_
#define ROAN_TRAIL_KINETOPHONE_GLIB_POPPLER_COMPAT_HPP_

#include <poppler.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Color;
  }

  namespace Kinetophone_glib
  {
    class Poppler_compat
    {
    public:
      static void hide_markup_annotation(PopplerAnnotMarkup* markup_annotation)
      {
        // do nothing if before Poppler 0.16.0, otherwise
        // effectively hide the annotation from rendering by setting
        // the opacity to 0.0 and making the popup closed
#if POPPLER_CHECK_VERSION(0, 16, 0)
        poppler_annot_markup_set_opacity(markup_annotation, 0.0);
        poppler_annot_markup_set_popup_is_open(markup_annotation, false);
#endif
      }

      static bool markup_annotations_are_rendered()
      {
        // markup annotations are not rendered before Poppler 0.16.0
#if POPPLER_CHECK_VERSION(0, 16, 0)
        return true;
#else
        return false;
#endif
      }

#if POPPLER_CHECK_VERSION(0, 17, 0)
      //
      static GdkPixbuf* poppler_page_get_thumbnail_pixbuf(PopplerPage *page,
                                                          const Roan_trail::Kinetophone::Color& background_color);
      static void poppler_page_render_to_pixbuf(PopplerPage *page,
                                                int src_x,
                                                int src_y,
                                                int src_width,
                                                int src_height,
                                                double scale,
                                                int rotation,
                                                GdkPixbuf *pixbuf);
#else
      static GdkPixbuf* poppler_page_get_thumbnail_pixbuf(PopplerPage *page,
                                                          const Roan_trail::Kinetophone::Color& background_color)
      {
        static_cast<void>(background_color); // avoid unused warning

        return ::poppler_page_get_thumbnail_pixbuf(page);
      }

      static void poppler_page_render_to_pixbuf(PopplerPage *page,
                                                int src_x,
                                                int src_y,
                                                int src_width,
                                                int src_height,
                                                double scale,
                                                int rotation,
                                                GdkPixbuf *pixbuf)
      {
        ::poppler_page_render_to_pixbuf(page,
                                        src_x,
                                        src_y,
                                        src_width,
                                        src_height,
                                        scale,
                                        rotation,
                                        pixbuf);
      }
#endif
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_GLIB_POPPLER_COMPAT_HPP_
