// PDF_slide_collection_glib_impl.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

//
// Implementation of Kinetophone PDF slide collection
//

#ifndef ROAN_TRAIL_KINETOPHONE_GLIB_PDF_SLIDE_COLLECTION_GLIB_IMPL_HPP_
#define ROAN_TRAIL_KINETOPHONE_GLIB_PDF_SLIDE_COLLECTION_GLIB_IMPL_HPP_

#include <gdkmm/pixbuf.h> // needs to be included first
#include <kinetophone/Image_types.hpp>
#include <kinetophone/Slide.hpp>
#include <poppler.h>
#include <string>
#include <vector>

namespace Gdk
{
  class Pixbuf;
}

namespace Glib
{
  template <class T> class RefPtr;
}

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Error_param;
  }

  namespace Kinetophone_impl
  {
    class PDF_slide_collection_glib_impl
    {
    public:
      // constructor/destructor
      PDF_slide_collection_glib_impl();
      virtual ~PDF_slide_collection_glib_impl();
      // implementation functions
      bool image_for_slide_at(int slide_index,
                              const Roan_trail::Kinetophone::Rect_size& suggested_size,
                              const Roan_trail::Kinetophone::Color& fill_color,
                              Glib::RefPtr<Gdk::Pixbuf>& return_image) const;
      void thumbnail_for_slide_at(int slide_index,
                                  const Roan_trail::Kinetophone::Color& fill_color,
                                  Glib::RefPtr<Gdk::Pixbuf>& return_image) const;
      Roan_trail::Kinetophone::Rect_size max_bounds(int slide_count, int resolution) const;
      bool process_source_with_notes(const std::string& source_path,
                                     bool import_PDF_notes,
                                     std::vector<Roan_trail::Kinetophone::Slide<Glib::RefPtr<Gdk::Pixbuf> >*>&
                                     return_slides,
                                     Roan_trail::Kinetophone::Error_param& return_error);
      bool load_document(const std::string& source_path,
                         Roan_trail::Kinetophone::Error_param& return_error);
    private:
      PopplerDocument* m_document;
      // prevent compiler from generating
      PDF_slide_collection_glib_impl(const PDF_slide_collection_glib_impl& slide_collection);
      PDF_slide_collection_glib_impl& operator=(const PDF_slide_collection_glib_impl& slide_collection);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_GLIB_PDF_SLIDE_COLLECTION_GLIB_IMPL_HPP_
