// Narration_synthesizer.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_NARRATION_SYNTHESIZER_HPP_
#define ROAN_TRAIL_KINETOPHONE_NARRATION_SYNTHESIZER_HPP_

#include <kinetophone/common.hpp>
#include <string>
#include <vector>

namespace xmlpp
{
  class Node;
}

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Action_recorder;
    class Error_param;
    class Speech_synthesizer;
    class Speech_synthesizer_config;
    class Segment;

    class Narration_synthesizer
    {
    public:
      // constructor/destructor
      Narration_synthesizer();
      virtual ~Narration_synthesizer();
      // control
      //
      //   startup/shutdown functions
      bool startup(Speech_synthesizer_config& config, Error_param& return_error);
      bool shutdown(bool completed, Error_param& return_error);
      //   narration functions
      bool speak(Long_int index,
                 const std::string& text,
                 Error_param& return_error);
      bool end(Error_param& return_error);
      // accessors
      void recorded_time(std::string &return_recorded_time, char separator = ':') const;
      void recorded_time_for_current_index(std::string &return_recorded_time, char separator = ':') const;
      bool frames(Long_int& return_total_frames,
                  Long_int& return_index_frames,
                  Error_param& return_error) const;
      bool segments(std::vector<Segment>& return_segments, Error_param& return_error) const;
      const Speech_synthesizer_config* config() const;
      std::string output_file() const;
      bool have_recording() const;
      bool space_available(Long_int& return_bytes_available,
                           double& return_fraction_available,
                           double& return_seconds_remaining) const;
      bool output_file_size(Long_int& return_file_size, double& return_data_rate) const;
      Long_int frames_written_count() const;
      // load/save
      bool save_as_XML(const std::string& file_path,
                       xmlpp::Node* XML_node,
                       Error_param& return_error);
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      bool m_started;
      bool m_first_speech;
      Action_recorder* m_action_recorder;
      Speech_synthesizer* m_speech_synthesizer;
      mutable std::vector<Segment> m_segment_cache;
      std::string m_temporary_directory;
      Long_int m_index_frames_written_count;
      // prevent compiler from generating
      Narration_synthesizer(const Narration_synthesizer& synth);
      Narration_synthesizer& operator=(const Narration_synthesizer& synth);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_NARRATION_SYNTHESIZER_HPP_
