// Movie_builder_config.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_MOVIE_BUILDER_CONFIG_HPP_
#define ROAN_TRAIL_KINETOPHONE_MOVIE_BUILDER_CONFIG_HPP_

#include <kinetophone/Image_types.hpp>
#include <string>

// helper struct to store movie builder settings

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Color;
    struct Movie_config;

    struct Movie_builder_config
    {
    public:
      // constructor/destructor
      Movie_builder_config();
      ~Movie_builder_config();
      // structure data members
      Movie_config *movie;
      struct Output_struct
      {
        Output_struct();
        std::string movie_name;
        std::string temporary_directory;
        std::string directory;
        bool file_overwrite;
        bool create_multiple_movies;
        bool temporary_movies;
      } output;
      struct Movie_attributes_struct
      {
        Movie_attributes_struct();
        bool square_pixels;
        bool silence_gaps;
        int silence_gap_length;
        double full_resolution_scale;
        bool preserve_source_transparency;
        Color aspect_fill_color;
        Color transparency_color;
        Color PDF_fill_color;
        bool crop_image_to_frame;
        bool image_interpolation;
      } movie_attributes;
      bool quiet;
      bool verbose;
      bool skip_build_warnings;
    private:
      // prevent compiler from generating
      Movie_builder_config(Movie_builder_config& c);
      Movie_builder_config& operator=(Movie_builder_config& c);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_MOVIE_BUILDER_CONFIG_HPP_
