// Kinetophone_dir_slide_collection.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

// A directory slide collection using GLib

#ifndef ROAN_TRAIL_KINETOPHONE_GLIB_DIR_SLIDE_COLLECTION_GLIB_HPP_
#define ROAN_TRAIL_KINETOPHONE_GLIB_DIR_SLIDE_COLLECTION_GLIB_HPP_

#include <gdkmm/pixbuf.h> // Dir_slide_collection.hpp needs this included first
#include <kinetophone/Dir_slide_collection.hpp>
#include <kinetophone/Image_types.hpp>
#include <string>
#include <vector>

namespace Gdk
{
  class Pixbuf;
}

namespace Glib
{
  template <class T> class RefPtr;
}

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Error_param;
  }

  namespace Kinetophone_glib
  {
    class Dir_slide_collection_glib
      : public Roan_trail::Kinetophone::Dir_slide_collection<Glib::RefPtr<Gdk::Pixbuf> >
    {
    public:
      // constructor/destructor
      Dir_slide_collection_glib()
        : Roan_trail::Kinetophone::Dir_slide_collection<Glib::RefPtr<Gdk::Pixbuf> >() {}
      virtual ~Dir_slide_collection_glib() {}
      // accessors
      virtual bool image_for_slide_at(int slide_index,
                                      const Roan_trail::Kinetophone::Rect_size& suggested_size,
                                      Glib::RefPtr<Gdk::Pixbuf>& return_image) const;
      virtual void thumbnail_for_slide_at(int slide_index, Glib::RefPtr<Gdk::Pixbuf>& return_image) const;
      virtual Roan_trail::Kinetophone::Rect_size max_bounds() const;
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
      //
      virtual bool mf_process_source_images_with_notes(const std::vector<std::string>& image_paths,
                                                       const std::string& source_path,
                                                       Roan_trail::Kinetophone::Error_param& return_error);
    private:
      // prevent compiler from generating
      Dir_slide_collection_glib(const Dir_slide_collection_glib& dir_slide_collection);
      Dir_slide_collection_glib& operator=(const Dir_slide_collection_glib& dir_slide_collection);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_GLIB_DIR_SLIDE_COLLECTION_GLIB_HPP_
