// Application.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

// Abstract base, application class

#ifndef ROAN_TRAIL_KINETOPHONE_APPLICATION_HPP_
#define ROAN_TRAIL_KINETOPHONE_APPLICATION_HPP_

#include <string>

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Application
    {
    public:
      virtual ~Application();
      // accessors
      const int argc() { return m_argc; }
      const char** argv() { return m_argv; }
      const std::string &installation_dir() { return m_installation_dir; }
      static Application* application();
      // mutators
      void set_installation_dir(const std::string& installation_dir);
      // other
      virtual int run() = 0;
      virtual void terminate(int code, const std::string &message);
    protected:
      Application(int argc, const char** argv);
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      const int m_argc;
      const char** m_argv;
      std::string m_installation_dir;
      static Application *m_application;
      static bool m_class_initialized;
      // prevent compiler from generating
      Application(const Application& app);
      Application& operator=(const Application& app);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_APPLICATION_HPP_
