// Kinetophone_dbus_server.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_DBUS_SERVER_HPP_
#define ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_DBUS_SERVER_HPP_

#include <dbus-c++/dbus.h>
#include <kinetophone/common.hpp>
#include "Kinetophone_dbus_server_glue.hpp"
#include <string>
#include <vector>
#include <map>

namespace Roan_trail
{
  namespace Kinetophone_app
  {
    typedef std::map<std::string, std::string> Error_dictionary;

    class Kinetophone_dbus_recorder;

    class Kinetophone_dbus_server
      : public com::roantrail::dbus::kinetophone_adaptor,
        public DBus::IntrospectableAdaptor,
        public DBus::ObjectAdaptor
    {
    public:
      explicit Kinetophone_dbus_server(DBus::Connection& connection);
      // DBUS interface
      //   control
      void create_recorder(std::string& return_recorder_path,
                           bool& return_have_error,
                           Error_dictionary& return_error);
      void remove_recorder(const std::string& recorder_path,
                           bool& return_have_error,
                           Error_dictionary& return_error);
      void list_recorders(std::vector<std::string>& return_recorder_paths,
                           bool& return_have_error,
                           Error_dictionary& return_error);
    protected:
      bool mf_invariant(bool check_base_class = true) const;
    private:
      // data members
      std::map<std::string, Kinetophone_dbus_recorder*> m_recorders;
      Roan_trail::Kinetophone::Long_int m_recorder_ID;
      // prevent compiler from generating
      Kinetophone_dbus_server(const Kinetophone_dbus_server& server);
      Kinetophone_dbus_server& operator=(const Kinetophone_dbus_server& server);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_DBUS_SERVER_HPP_
