// Kinetophone_console_controller.hpp
//
// Copyright 2011, 2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_CONSOLE_CONTROLLER_HPP_
#define ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_CONSOLE_CONTROLLER_HPP_

#include "Console_controller.hpp"

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Error_param;
    class Kinetophone_model;
  }

  namespace Kinetophone_app
  {
    class Kinetophone_console_view;

    class Kinetophone_console_controller : public Console_controller
    {
    public:
      // constructor/destructor/copy
      Kinetophone_console_controller(Roan_trail::Kinetophone::Kinetophone_model& model,
                                     Kinetophone_console_view& view);
      //
      virtual bool process_input(bool& return_done, Roan_trail::Kinetophone::Error_param& return_error);
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      Roan_trail::Kinetophone::Kinetophone_model& m_model;
      Kinetophone_console_view& m_view;
      bool m_quit_on_confirm;
      //
      static Kinetophone_console_controller* m_instance; // singleton by convention
      // prevent compiler from generating
      Kinetophone_console_controller(const Kinetophone_console_controller& c);
      Kinetophone_console_controller& operator=(const Kinetophone_console_controller& c);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_CONSOLE_CONTROLLER_HPP_
