// Kinetophone_console_config.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_CONSOLE_CONFIG_HPP_
#define ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_CONSOLE_CONFIG_HPP_

#include <string>

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Error_param;
    class Sound_recorder_config;
  }

  namespace Kinetophone_app
  {
    // Helper struct to store console recorder application settings.
    // It is a struct instead of a class since it primarily only
    // aggregates various data
    struct Kinetophone_console_config
    {
    public:
      // constructor/destructor/copy
      Kinetophone_console_config();
      Kinetophone_console_config(const Kinetophone_console_config& config);
      Kinetophone_console_config& operator=(const Kinetophone_console_config& config);
      virtual ~Kinetophone_console_config();
      // typedef
      // structure members
      std::string help_message;
      bool has_level_meter;
      struct Level_meter_struct
      {
        Level_meter_struct();
        bool has_level;
        int width;
        bool use_max_width;
        bool model_ballistics;
        int attack_period; // milliseconds
        int decay_period; // milliseconds
        int peak_hold_period; // milliseconds
      } level_meter;
      int update_rate;
      bool show_file_size;
      bool show_available;
      bool show_audio_info;
      bool show_overflow_count;
      bool detailed_error;
      std::string custom_installation_dir;
      Roan_trail::Kinetophone::Sound_recorder_config* sound_recorder_config;
      // defaults
      static const int default_update_rate;
      static const int default_level_meter_width;
      // command class constants
      static const int command_error          = 0;
      static const int command_record         = 1;
      static const int command_help           = 2;
      static const int command_list_devices   = 3;
      static const int command_output_version = 4;
      //
      int parse_program_options(int argc,
                                const char** argv,
                                Roan_trail::Kinetophone::Error_param& return_error);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_CONSOLE_CONFIG_HPP_
