// Kinetophone_console_app.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_CONSOLE_APP_HPP_
#define ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_CONSOLE_APP_HPP_

#include "Console_app.hpp"
#include <string>

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Error_param;
    class Kinetophone_model;
  }

  namespace Kinetophone_app
  {
    class Kinetophone_console_view;
    class Kinetophone_console_controller;
    class Kinetophone_console_config;

    class Kinetophone_console_app : public Console_app
    {
    public:
      // Constructor/destructor/copy
      Kinetophone_console_app(int argc, const char** argv);
      virtual ~Kinetophone_console_app();
      virtual int run();
      //
      virtual void terminate(int code, const std::string& message);
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      Kinetophone_console_config* const m_config;
      Roan_trail::Kinetophone::Kinetophone_model* const m_model;
      Kinetophone_console_controller* m_controller;
      Kinetophone_console_view* m_view;
      //
      bool mf_record(Roan_trail::Kinetophone::Error_param& return_error);
      bool mf_run_IO_loop(Roan_trail::Kinetophone::Error_param& return_error);
      // prevent compiler from generating
      Kinetophone_console_app(const Kinetophone_console_app& app);
      Kinetophone_console_app& operator=(const Kinetophone_console_app& app);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_CONSOLE_APP_HPP_
