// Console_level_meter_view.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

//
// This code was based on jackmeter.c:
//
//   jackmeter.c
//   Simple console based Digital Peak Meter for JACK
//   Copyright (C) 2005  Nicholas J. Humfrey
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef ROAN_TRAIL_KINETOPHONE_APP_CONSOLE_LEVEL_METER_VIEW_HPP_
#define ROAN_TRAIL_KINETOPHONE_APP_CONSOLE_LEVEL_METER_VIEW_HPP_

#include <kinetophone/Level_meter_view.hpp>
#include <string>

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Error_param;
  }

  namespace Kinetophone_app
  {
    class Console_level_meter_view : public Roan_trail::Kinetophone::Level_meter_view
    {
    public:
      // constructor/destructor/copy
      Console_level_meter_view(int channels,
                               int rate,
                               int width,
                               bool print_level = false,
                               bool model_ballistics = true,
                               int attack_period = -1,
                               int decay_period = -1,
                               int peak_hold_period = -1);
      virtual ~Console_level_meter_view();
      // view update
      virtual bool update(Roan_trail::Kinetophone::Error_param& return_error);
      // accessors
      const std::string& meter() const { return m_meter; }
      const std::string& scale() const { return m_scale; }
      const std::string& scale_label() const { return m_scale_label; }
      // mutators
      void set_width(int width);
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      int m_width;
      bool m_print_level;
      std::string m_meter;
      std::string m_scale;
      std::string m_scale_label;
      //
      void mf_set_meter();
      void mf_set_scale();
      // prevent compiler from generating
      Console_level_meter_view(const Console_level_meter_view& meter);
      Console_level_meter_view& operator=(const Console_level_meter_view& meter);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_APP_CONSOLE_LEVEL_METER_VIEW_HPP_
