// Kinetophone_movie_builder.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_MOVIE_BUILDER_HPP_
#define ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_MOVIE_BUILDER_HPP_

#include <kinetophone/common.hpp>
#include <kinetophone/Movie_builder.hpp>
#include <gdkmm/pixbuf.h>

namespace Roan_trail
{
  namespace Kinetophone_app
  {
    struct Kinetophone_builder_config;
    class Kinetophone_builder_model;

    class Kinetophone_movie_builder : public Roan_trail::Kinetophone::Movie_builder
    {
    public:
      Kinetophone_movie_builder(const Kinetophone_builder_config& config,
                                const Kinetophone_builder_model& model);
      virtual ~Kinetophone_movie_builder();
    protected:
      virtual const uint8_t* mf_generate_image(Roan_trail::Kinetophone::Long_int slide_index,
                                               bool& return_used_default);
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      const Kinetophone_builder_config& m_config;
      const Kinetophone_builder_model& m_model;
      Glib::RefPtr<Gdk::Pixbuf> m_pixbuf_cache;
      Glib::RefPtr<Gdk::Pixbuf> m_pixbuf_convert_cache;
      // prevent compiler from generating
      Kinetophone_movie_builder(const Kinetophone_movie_builder& b);
      Kinetophone_movie_builder& operator=(const Kinetophone_movie_builder& b);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_MOVIE_BUILDER_HPP_
