// Kinetophone_builder_config.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_BUILDER_CONFIG_HPP_
#define ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_BUILDER_CONFIG_HPP_

#include <string>

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Error_param;
    struct Movie_builder_config;
  }

  namespace Kinetophone_app
  {
    // Helper struct to store builder application settings.
    // It is a struct instead of a class since it primarily only
    // aggregates various data
    struct Kinetophone_builder_config
    {
    public:
      // constructor/destructor/copy
      Kinetophone_builder_config();
      Kinetophone_builder_config(const Kinetophone_builder_config& config);
      Kinetophone_builder_config& operator=(const Kinetophone_builder_config& config);
      virtual ~Kinetophone_builder_config();
      // structure members
      std::string help_message;
      std::string session_file_path;
      std::string image_source_path;
      Roan_trail::Kinetophone::Movie_builder_config* movie_builder_config;
      bool detailed_error;
      bool quit_on_prebuild_warnings;
      std::string custom_installation_dir;
      // command class constants
      static const int command_error          = 0;
      static const int command_build          = 1;
      static const int command_help           = 2;
      static const int command_output_version = 3;
      //
      int parse_program_options(int argc,
                                const char** argv,
                                Roan_trail::Kinetophone::Error_param& return_error);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_BUILDER_CONFIG_HPP_
