// Kinetophone_vox_model.hpp
//
// Copyright 2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef KINETOPHONE_VOX_MODEL_HPP_
#define KINETOPHONE_VOX_MODEL_HPP_

#include <string>

namespace Gdk
{
  class Pixbuf;
}

namespace Glib
{
  template <class T> class RefPtr;
}

namespace Roan_trail
{
  class Error_param;

  namespace Recorder
  {
    class Narration_synthesizer;
  }
  namespace Source
  {
    template <class Image> class Slide_collection;
  }

  namespace Kinetophone
  {
    class Kinetophone_vox_config;

    class Kinetophone_vox_model
    {
    public:
      // enum
      enum Slides_source_type
        {
          directory_source,
          PDF_source
        };
      // constructor/destructor
      Kinetophone_vox_model(const Kinetophone_vox_config& vox_config);
      ~Kinetophone_vox_model();
      // accessors
      const Roan_trail::Source::Slide_collection<Glib::RefPtr<Gdk::Pixbuf> >* slides() const { return m_slides; }
      Roan_trail::Source::Slide_collection<Glib::RefPtr<Gdk::Pixbuf> >* slides() { return m_slides; }
      Roan_trail::Recorder::Narration_synthesizer* narration_synthesizer() { return m_synthesizer; }
      const Roan_trail::Recorder::Narration_synthesizer* narration_synthesizer() const { return m_synthesizer; }
      // load/save
      bool load_from_XML(const std::string& file_path, Error_param& return_error);
      bool load_from_PDF_source(const std::string& PDF_source_path, Error_param& return_error);
      bool save_as_XML(const std::string& file_path,
                       bool overwrite,
                       Error_param& return_error) const;
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      const Kinetophone_vox_config& m_vox_config;
      Roan_trail::Source::Slide_collection<Glib::RefPtr<Gdk::Pixbuf> >* m_slides;
      Roan_trail::Recorder::Narration_synthesizer* m_synthesizer;
      Slides_source_type m_slides_source;
      // prevent compiler from generating
      Kinetophone_vox_model(const Kinetophone_vox_model& vox_model);
      Kinetophone_vox_model& operator=(const Kinetophone_vox_model& vox_model);
    };
  }
}

#endif // KINETOPHONE_VOX_MODEL_HPP_
