// Kinetophone_vox_app.hpp
//
// Copyright 2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef KINETOPHONE_VOX_APP_HPP_
#define KINETOPHONE_VOX_APP_HPP_

#include "../base/Application.hpp"
#include <string>

namespace Roan_trail
{
  class Error_param;

  namespace Kinetophone
  {
    class Kinetophone_vox_config;
    class Kinetophone_vox_model;
    class Kinetophone_vox_manager;

    class Kinetophone_vox_app : public Application
    {
    public:
      // Constructor/destructor/copy
      Kinetophone_vox_app(int argc, const char** argv);
      virtual ~Kinetophone_vox_app();
      //
      virtual int run();
      virtual void terminate(int code, const std::string& message);
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      Kinetophone_vox_config* m_config;
      Kinetophone_vox_model* m_model;
      Kinetophone_vox_manager* m_vox_manager;
      //
      bool mf_synthesize(Error_param& return_error);
      // prevent compiler from generating
      Kinetophone_vox_app(const Kinetophone_vox_app& app);
      Kinetophone_vox_app& operator=(const Kinetophone_vox_app& app);
    };
  }
}

#endif // KINETOPHONE_VOX_APP_HPP_
