// Kinetophone_narrator_model.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef KINETOPHONE_NARRATOR_MODEL_HPP_
#define KINETOPHONE_NARRATOR_MODEL_HPP_

#include <string>

namespace Gdk
{
  class Pixbuf;
}

namespace Glib
{
  template <class T> class RefPtr;
}

namespace Roan_trail
{
  class Error_param;

  namespace Recorder
  {
    class Narration_recorder;
  }
  namespace Source
  {
    template <class Image> class Slide_collection;
  }

  namespace Kinetophone
  {
    class Kinetophone_narrator_config;

    class Kinetophone_narrator_model
    {
    public:
      // enum
      enum Slides_source_type
        {
          directory_source,
          PDF_source
        };
      // constructor/destructor
      explicit Kinetophone_narrator_model(const Kinetophone_narrator_config& config);
      ~Kinetophone_narrator_model();
      // accessors
      const Roan_trail::Source::Slide_collection<Glib::RefPtr<Gdk::Pixbuf> >* slides() const { return m_slides; }
      Roan_trail::Source::Slide_collection<Glib::RefPtr<Gdk::Pixbuf> >* slides() { return m_slides; }
      const Roan_trail::Recorder::Narration_recorder* narration_recorder() const { return m_recorder; }
      Roan_trail::Recorder::Narration_recorder* narration_recorder() { return m_recorder; }
      bool is_dirty() const { return m_dirty; }
      // mutators
      void set_dirty(bool dirty = true) { m_dirty = dirty; }
      // commands
      bool import_from_XML(const std::string& file_path, Error_param& return_error);
      bool export_as_XML(const std::string& file_path, Error_param& return_error) const;
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      Roan_trail::Source::Slide_collection<Glib::RefPtr<Gdk::Pixbuf> >* m_slides;
      Slides_source_type m_slides_source;
      Roan_trail::Recorder::Narration_recorder* m_recorder;
      bool m_dirty;
      // prevent compiler from generating
      Kinetophone_narrator_model(const Kinetophone_narrator_model& narrator_model);
      Kinetophone_narrator_model& operator=(const Kinetophone_narrator_model& narrator_model);
    };
  }
}

#endif // KINETOPHONE_NARRATOR_MODEL_HPP_
