// Kinetophone_PDF_slide_collection.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef KINETOPHONE_PDF_SLIDE_COLLECTION_HPP_
#define KINETOPHONE_PDF_SLIDE_COLLECTION_HPP_

#include <gdkmm/pixbuf.h> // PDF_slide_collection.hpp needs this included first
#include "../base/Image_types.hpp"
#include "../base/PDF_slide_collection.hpp"
#include <poppler.h>
#include <string>

namespace Gdk
{
  class Pixbuf;
}

namespace Glib
{
  template <class T> class RefPtr;
}

namespace Roan_trail
{
  class Error_param;

  namespace Kinetophone
  {
    class Kinetophone_PDF_slide_collection
      : public Roan_trail::Source::PDF_slide_collection<Glib::RefPtr<Gdk::Pixbuf> >
    {
    public:
      // constructor/destructor
      Kinetophone_PDF_slide_collection();
      virtual ~Kinetophone_PDF_slide_collection();
      // accessors
      virtual bool image_for_slide_at(int slide_index,
                                      const Rect_size& suggested_size,
                                      Glib::RefPtr<Gdk::Pixbuf>& return_image) const;
      virtual void thumbnail_for_slide_at(int slide_index, Glib::RefPtr<Gdk::Pixbuf>& return_image) const;
      virtual Rect_size max_bounds() const;
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
      //
      virtual bool mf_process_source_with_notes(const std::string& source_path, Error_param& return_error);
      virtual bool mf_load_document(const std::string& source_path, Error_param& return_error);
    private:
      PopplerDocument* m_document;
      // prevent compiler from generating
      Kinetophone_PDF_slide_collection(const Kinetophone_PDF_slide_collection& slide_collection);
      Kinetophone_PDF_slide_collection& operator=(const Kinetophone_PDF_slide_collection& slide_collection);
    };
  }
}

#endif // KINETOPHONE_PDF_SLIDE_COLLECTION_HPP_
