// Kinetophone_builder_view.hpp
//
// Copyright 2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef KINETOPHONE_BUILDER_VIEW_HPP_
#define KINETOPHONE_BUILDER_VIEW_HPP_

#include <string>

namespace Roan_trail
{
  class Error;

  namespace Kinetophone
  {
    class Kinetophone_builder_view
    {
    public:
      // constructor/destructor
      Kinetophone_builder_view() {}
      // commands
      static void output_message(const std::string& message);
      static void output_error(const Error* error);
      static void output_error(const std::string& message);
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      // prevent compiler from generating
      Kinetophone_builder_view(const Kinetophone_builder_view& app);
      Kinetophone_builder_view& operator=(const Kinetophone_builder_view& app);
    };
  }
}

#endif // KINETOPHONE_BUILDER_VIEW_HPP_
