// Poppler_error.cpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#include "Poppler_error.hpp"
#include "../common.hpp"
#include <glib.h>
#include <string>

using std::string;
using namespace Roan_trail::Source;

namespace
{
  const char* ic_default_poppler_error_message = "Unknown Poppler error.";
}

//
// Constructor/destructor/copy
//

Poppler_error::Poppler_error(const char* file,
                             const char* function,
                             int line,
                             const string& file_path,
                             GError* base_error)
  : Error(file,
          function,
          line,
          (base_error ? base_error->code : 0),
          0)
{
  Error_dictionary& dict = error_dictionary();

  const char* error_message = 0;
  if (base_error)
  {
    error_message = base_error->message;
    dict[poppler_domain_error_key] = string(g_quark_to_string(base_error->domain));
  }
  if (!error_message)
  {
    error_message = ic_default_poppler_error_message;
  }
  dict[Error::diagnostic_error_key] = string(error_message);

  if ("" != file_path)
  {
    dict[Error::file_path_error_key] = string(file_path);
  }

  if (base_error)
  {
    g_error_free(base_error);
  }

  postcondition(mf_invariant(false));
}

//
// Error keys
//

const string Poppler_error::poppler_domain_error_key = "poppler_domain_error_key";

//
// Protected member functions
//

bool Poppler_error::mf_invariant(bool check_base_class) const
{
  bool return_value = false;

  return_value = (!check_base_class || Error::mf_invariant(check_base_class));

  return return_value;
}
