// Boost_error.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef BOOST_ERROR_HPP_
#define BOOST_ERROR_HPP_

#include "Error.hpp"
#include <string>

namespace boost
{
  namespace system
  {
    class error_code;
  }
}

namespace Roan_trail
{
  class Boost_error : public Error
  {
  public:
    // constructor/destructor/copy
    Boost_error(const char* file,
                const char* function,
                int line,
                const boost::system::error_code& ec,
                const Error* base_error = 0);
    Boost_error(const char* file,
                const char* function,
                int line,
                const std::string& diagnostic,
                const Error* base_error = 0);
    virtual Boost_error* clone() const { return new Boost_error(*this); }
    // error key constants
    static const std::string program_options_error_key;
    // other
    virtual std::string error_class() const { return "Boost_error"; }
    static const int no_error;
  protected:
    // invariant check
    bool mf_invariant(bool check_base_class = true) const;
  private:
    // prevent compiler from generating
    Boost_error operator=(const Boost_error& e);
  };
}

#endif // BOOST_ERROR_HPP_
