// Sound_file_compat.hpp
//
// Copyright 2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

// Compatibility class for libsndfile

#ifndef SNDFILE_COMPAT_HPP_
#define SNDFILE_COMPAT_HPP_

#include "common.hpp"
#include <map>

namespace Roan_trail
{
  namespace Recorder
  {
    typedef int File_type;
    typedef int Data_format;
    typedef int Endianness;
    class Sound_file_config;

    class Sndfile_compat
    {
    public:
      // Sound_file_config to sndfile
      //   from sndfile
      static bool file_type_for_sf_format(int format, File_type& return_file_type);
      static bool data_format_for_sf_format(int format, Data_format& return_data_format);
      static bool endianness_for_sf_format(int format,
                                           bool convert,
                                           Endianness& return_endianness);
      //   to sndfile
      static bool sf_format_for_file_type(File_type file_type, int& return_format);
      static bool sf_format_for_data_format(Data_format data_format, int& return_format);
      static bool sf_format_for_endianness(Endianness endianness, int& return_format);
      static bool sf_format_for_config(const Sound_file_config& config, int& return_format);
    private:
      // prevent compiler from generating
      static std::map<int, File_type> m_sf_format_file_type_map;
      static std::map<int, File_type> m_sf_format_data_format_map;
      static std::map<int, File_type> m_sf_format_endianness_map;
      Sndfile_compat();
      Sndfile_compat(const Sndfile_compat& c);
      Sndfile_compat& operator=(const Sndfile_compat& c);
    };
  }
}

#endif // SNDFILE_COMPAT_HPP_
