// Movie_builder_config.cpp
//
// Copyright 2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#include "Movie_builder_config.hpp"
#include "common.hpp"
#include "Image_types.hpp"
#include "Movie_config.hpp"
#include "File_manager.hpp"
#include <string>

using std::string;
using namespace Roan_trail::Builder;

//
// Internal helpers
//
namespace
{
  const string ic_default_movie_name = "movie";
  const double ic_default_full_resolution_scale = 1.0;
  const int ic_default_movie_gap_length = 30;
  const uint32_t ic_default_PDF_fill_color = 0xFFFFFFFF; // white
}

//
// Constructor/destructor/copy
//

Movie_builder_config::Movie_builder_config()
  // setup some reasonable defaults
  : movie(new Movie_config),
    output(),
    movie_attributes(),
    quiet(false),
    verbose(false),
    skip_build_warnings(false)
{
}

Movie_builder_config::~Movie_builder_config()
{
  delete movie;
}

Movie_builder_config::Output_struct::Output_struct()
  // setup some reasonable defaults
  : movie_name(ic_default_movie_name),
    temporary_directory(File_manager::temporary_directory()),
    directory("."),
    file_overwrite(false),
    create_multiple_movies(false),
    temporary_movies(false)
{
}

Movie_builder_config::Movie_attributes_struct::Movie_attributes_struct()
  : square_pixels(false),
    silence_gaps(false),
    silence_gap_length(ic_default_movie_gap_length),
    full_resolution_scale(ic_default_full_resolution_scale),
    preserve_source_transparency(true),
    aspect_fill_color(),
    transparency_color(),
    PDF_fill_color(Color(ic_default_PDF_fill_color)),
    crop_image_to_frame(false),
    image_interpolation(true)
{
}
