// Kinetophone_model.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef KINETOPHONE_MODEL_HPP_
#define KINETOPHONE_MODEL_HPP_

#include "Model.hpp"

namespace Roan_trail
{
  namespace Recorder
  {
    class Sound_recorder;
  }

  namespace Kinetophone
  {
    class Kinetophone_model : public Model
    {
    public:
      // constructor/destructor/copy
      Kinetophone_model();
      virtual ~Kinetophone_model();
      // accessors
      Roan_trail::Recorder::Sound_recorder* sound_recorder() { return m_sound_recorder; }
      const Roan_trail::Recorder::Sound_recorder* sound_recorder() const { return m_sound_recorder; }
      // mutators
      void clear();
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      Roan_trail::Recorder::Sound_recorder* const m_sound_recorder;
      // prevent compiler from generating
      Kinetophone_model(const Kinetophone_model& model);
      Kinetophone_model& operator=(const Kinetophone_model& model);
    };
  }
}

#endif // KINETOPHONE_MODEL_HPP_
