// Device_enum.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef DEVICE_ENUM_HPP_
#define DEVICE_ENUM_HPP_

#include <portaudio.h>
#include <string>

namespace Roan_trail
{
  class Error_param;

  namespace Recorder
  {
    class Device_enum
    {
    public:
      static bool list_devices(PaSampleFormat sample_format,
                               std::string& return_devices,
                               Error_param& return_error);
    private:
      // prevent compiler from generating
      Device_enum();
      Device_enum(const Device_enum& d);
      Device_enum& operator=(const Device_enum& d);
    };
  }
}

#endif // DEVICE_ENUM_HPP_
