// ActionRecorder.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ACTION_RECORDER_HPP_
#define ACTION_RECORDER_HPP_

#include "common.hpp"
#include "Recorder.hpp"
#include <vector>

namespace Roan_trail
{
  class Error_param;

  namespace Recorder
  {
    class Segment;

    struct Action
    {
    public:
      Action(int action_type_i,
             Long_int index_i,
             Long_int audio_frame_i)
        : action_type(action_type_i),
          index(index_i),
          audio_frame(audio_frame_i) {}
      Action& operator=(const Action& a);
      // data members
      const int action_type;
      const Long_int index;
      const Long_int audio_frame;
      // action types
      static const int start     = 0;
      static const int new_index = 1;
      static const int retake    = 2;
      static const int stop      = 3;
      static const int pause     = 4;
    };

    class Action_recorder : public Recorder
    {
    public:
      // constructor/destructor
      Action_recorder();
      virtual ~Action_recorder();
      // control
      //   basic Recorder functions
      void record(Long_int index = 0, Long_int audio_frame = 0);
      void pause();
      void stop(Long_int audio_frame);
      //   action recorder functions
      void new_index(Long_int audio_frame, Long_int index = 0);
      void retake(Long_int audio_frame);
      // accessors
      Long_int index() const { return m_index; }
      bool segments(std::vector<Segment>& return_segments, Error_param& return_error) const;
      // mutators
      void set_audio_frame_rate(Long_int audio_frame_rate) { m_current_audio_frame_rate = audio_frame_rate; }
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      Long_int m_current_audio_frame_rate; // to convert to reference frame rate
      Long_int m_index;
      std::vector<Action> m_actions;
      bool mf_scan_segments(std::vector<Segment>& return_segments, Error_param& return_error) const;
      // prevent compiler from generating
      Action_recorder(const Action_recorder& recorder);
      Action_recorder& operator=(const Action_recorder& recorder);
    };
  }
}

#endif // ACTION_RECORDER_HPP_
