// Kinetophone_vox_manager.hpp
//
// Copyright 2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef KINETOPHONE_VOX_MANAGER_HPP_
#define KINETOPHONE_VOX_MANAGER_HPP_

#include "../base/common.hpp"
#include <string>

namespace Gdk
{
  class Pixbuf;
}

namespace Glib
{
  template <class T> class RefPtr;
}

namespace Roan_trail
{
  class Error;
  class Error_param;
  class Logger;

  namespace Source
  {
    template <class I> class Slide;
  }

  namespace Kinetophone
  {
    struct Kinetophone_vox_config;
    class Kinetophone_vox_model;

    class Kinetophone_vox_manager
    {
    public:
      // Constructor/destructor/copy
      Kinetophone_vox_manager(const Kinetophone_vox_config& config,
                              Kinetophone_vox_model& model);
      ~Kinetophone_vox_manager();
      // accessors
      bool is_running() const  { return __sync_fetch_and_add(const_cast<int32_t*>(&m_running), 0x0); }
      bool is_cancelled() const { return __sync_fetch_and_add(const_cast<int32_t*>(&m_cancelled), 0x0); }
      // mutators
      void reset_cancel() {  __sync_and_and_fetch(&m_cancelled, 0x0); }
      // control
      bool setup_for_generate(Error_param& return_error);
      bool pregenerate_checks(Error_param& return_error);
      bool generate(Error_param& return_error);
      void cancel() {  __sync_or_and_fetch(&m_cancelled, 0x1); }
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      const Kinetophone_vox_config& m_config;
      Kinetophone_vox_model& m_model;
      Logger& m_logger;
      //
      std::string m_source_sound_file_path;
      //
      int32_t __attribute__ ((aligned (4))) m_running;
      int32_t __attribute__ ((aligned (4))) m_cancelled;
      //
      bool m_setup;
      // log messages
      void mf_log_slide(const Roan_trail::Source::Slide<Glib::RefPtr<Gdk::Pixbuf> >& slide);
      void mf_log_config();
      void mf_log_model();
      // log warning
      void mf_log_warning(const Error* warning, bool output_separator = true);
      // prevent compiler from generating
      Kinetophone_vox_manager(const Kinetophone_vox_manager& m);
      Kinetophone_vox_manager& operator=(const Kinetophone_vox_manager& m);
    };
  }
}

#endif // KINETOPHONE_VOX_MANAGER_HPP_
