; kinetophone_dbus_test_client.lisp
;
; Copyright 2011 Roan Trail, Inc.
;
; This file is part of Kinetophone.
;
; Kinetophone is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published
; by the Free Software Foundation, either version 2 of the License,
; or (at your option) any later version.
;
; Kinetophone is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
; General Public License for more details.  You should have received
; a copy of the GNU General Public License along with Kinetophone. If
; not, see <http://www.gnu.org/licenses/>.

;
; Emacs Lisp program to test Kinetophone DBus, should work in Emacs 23+
;
; Note: CTRL-J after an expression evaluates it in a Lisp Interaction
; (*scratch*) buffer
;

(require 'dbus)

(defun kinetophone-server-call (method &rest args)
  "call the Kinetophone server METHOD with ARGS over DBus"
  (apply 'dbus-call-method
         :session                          ; use the session bus
         "com.roantrail.dbus.kinetophone"  ; service name
         "/com/roantrail/dbus/kinetophone" ; path name
         "com.roantrail.dbus.kinetophone"  ; interface name
         method args))

(defun kinetophone-recorder-call (recorder-path method &rest args)
  "call the METHOD on the Kinetophone recorder at RECORDER-PATH with ARGS over DBus"
  (apply 'dbus-call-method
         :session                                   ; use the session bus
         "com.roantrail.dbus.kinetophone"           ; service name
         recorder-path                              ; path name
         "com.roantrail.dbus.kinetophone.recorder"  ; interface name
         method args))

(setq recorder-list (car (kinetophone-server-call "list_recorders")))
(setq create-return (kinetophone-server-call "create_recorder"))
(setq recorder-path (car create-return))

(setq startup-return
      (if (not (equal (cdr create-return) 't))
         (kinetophone-recorder-call recorder-path
                                    "startup"
;                                    '(:array :signature "{ss}")) ; default settings
                                    '(:array (:dict-entry "input_device" "3"))) ; custom settings
        '(t)))
(kinetophone-recorder-call recorder-path "enable_metering_RMS" 't)
;(kinetophone-recorder-call recorder-path "set_metering_channels" :int32 1)
(setq record-return
      (if (not (equal (car startup-return) 't))
         (kinetophone-recorder-call recorder-path
                                     "record_with_index"
                                     :int64 0)
        '(t)))

(message "recording for 5 seconds")

(if (not (equal (car record-return) 't))
     (sleep-for 5))
(setq stop-return
      (if (not (equal (car record-return) 't))
          (kinetophone-recorder-call recorder-path "stop")
        '(t)))
(setq output-file
       (if (not (equal (cdr create-return) 't))
           (kinetophone-recorder-call recorder-path "output_file")
         ""))
(setq remove-return
      (if (not (string-equal recorder-path ""))
          (kinetophone-server-call "remove_recorder" recorder-path)
        ('t)))

(message "recording ended")
