// Console_app.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef CONSOLE_APP_HPP_
#define CONSOLE_APP_HPP_

#include "../base/Application.hpp"
#include <string>

struct screen;

namespace Roan_trail
{
  class Model;
  class View;
  class Console_controller;
  class Error_param;

  class Console_app : public Application
  {
  public:
    // Constructor/destructor/copy
    Console_app(int argc, const char** argv);
    virtual ~Console_app();
    // accessors
    static Console_app *application();
    static bool full_screen() { return m_full_screen; }
    // mutators
    static bool set_full_screen(bool use_full_screen, Error_param& return_error);
    // other
    virtual void terminate(int code, const std::string& message);
  protected:
    // invariant check
    bool mf_invariant(bool check_base_class = true) const;
  private:
    static bool m_full_screen;
    static screen* m_screen;
    // prevent compiler from generating
    Console_app(const Console_app& app);
    Console_app& operator=(const Console_app& app);
  };
}

#endif // CONSOLE_APP_HPP_
