// Source_error.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef SOURCE_ERROR_HPP_
#define SOURCE_ERROR_HPP_

#include "Error.hpp"
#include <string>

namespace Roan_trail
{
  class Source_error : public Error
  {
  public:
    // constructor/destructor/copy
    Source_error(const char* file,
                 const char* function,
                 int line,
                 int code,
                 const std::string& diagnostic,
                 const std::string& file_path = "",
                 const Error* base_error = 0);
    Source_error(const char* file,
                 const char* function,
                 int line,
                 int code,
                 const Error* base_error = 0);
    virtual Source_error* clone() const { return new Source_error(*this); }
    // other
    virtual std::string error_class() const { return "Source_error"; }
    // error codes
    static const int none           = 0; // code for none should always be 0
    static const int general        = 1; // code for general error should always be 1
    static const int invalid_source = 2;
    static const int load           = 3;
    static const int save           = 4;
  protected:
    // invariant check
    bool mf_invariant(bool check_base_class = true) const;
  private:
    // prevent compiler from generating
    Source_error operator=(const Source_error &e);
  };
}

#endif // SOURCE_ERROR_HPP_
