// Source_error.cpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#include "Source_error.hpp"
#include "../common.hpp"
#include <string>

using std::string;
using namespace Roan_trail;

//
// Constructor/destructor/copy
//

Source_error::Source_error(const char* file,
                           const char* function,
                           int line,
                           int code,
                           const string& diagnostic,
                           const string& file_path,
                           const Error* base_error)
  : Error(file,
          function,
          line,
          code,
          base_error)
{
  if ("" != diagnostic)
  {
    error_dictionary()[Error::diagnostic_error_key] = diagnostic;
  }

  if ("" != file_path)
  {
    error_dictionary()[Error::file_path_error_key] = file_path;
  }

  postcondition(mf_invariant(false));
}

Source_error::Source_error(const char* file,
                           const char* function,
                           int line,
                           int code,
                           const Error* base_error)
  : Error(file,
          function,
          line,
          code,
          base_error)
{
  postcondition(mf_invariant(false));
}

//
// Error codes
//

const int Source_error::none;
const int Source_error::general;
const int Source_error::invalid_source;
const int Source_error::load;
const int Source_error::save;

//
// Protected member functions
//

bool Source_error::mf_invariant(bool check_base_class) const
{
  bool return_value = false;

  if ((code() < Source_error::none) || (code() > Source_error::save))
  {
    goto exit_point;
  }

  return_value = (!check_base_class || Error::mf_invariant(check_base_class));

  goto exit_point;

 exit_point:

  return return_value;
}
