// Portaudio_error.cpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#include "Portaudio_error.hpp"
#include "../common.hpp"
#include <portaudio.h>
#include <string>

using std::string;
using namespace Roan_trail::Recorder;

//
// Constructor/destructor/copy
//

Portaudio_error::Portaudio_error(PaError code,
                                 const char *portaudio_function_name,
                                 const Error *base_error)
  : Error(0,
          portaudio_function_name,
          0,
          code,
          base_error)
{
  const char *error_message = Pa_GetErrorText(code);
  if (error_message)
  {
    error_dictionary()[Error::diagnostic_error_key] = string(error_message);
  }

  postcondition(mf_invariant(false));
}


//
// Protected member functions
//

bool Portaudio_error::mf_invariant(bool check_base_class) const
{
  bool return_value = false;

  if (!file().empty() || line())
  {
    goto exit_point;
  }
  else
  {
    return_value = (!check_base_class || Error::mf_invariant(check_base_class));
  }

 exit_point:

  return return_value;
}
