// DBus_error.cpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#include "DBus_error.hpp"
#include "../common.hpp"
#include <string>
#include <dbus-c++/dbus.h>

using std::string;
using namespace Roan_trail;

//
// Constructor/destructor/copy
//
DBus_error::DBus_error(const char* file,
                       const char* function,
                       int line,
                       const DBus::Error& dbus_exception,
                       const Error *base_error)
  : Error(file,
          function,
          line,
          0,
          base_error)
{
  if (string("") != string(dbus_exception.name()))
  {
    error_dictionary()[Error::code_string_error_key] = dbus_exception.name();
  }

  if (string("") != string(dbus_exception.message()))
  {
    error_dictionary()[Error::diagnostic_error_key] = dbus_exception.message();
  }

  postcondition(mf_invariant(false));
}

//
// Protected member functions
//

bool DBus_error::mf_invariant(bool check_base_class) const
{
  bool return_value = false;

  if (0 != code())
  {
    goto exit_point;
  }

  return_value = (!check_base_class || Error::mf_invariant(check_base_class));

  goto exit_point;

 exit_point:

  return return_value;
}
