// Curses_error.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef CURSES_ERROR_HPP_
#define CURSES_ERROR_HPP_

#include "Error.hpp"
#include <map>
#include <string>

namespace Roan_trail
{
  class Curses_error : public Error
  {
  public:
    // constructor/destructor/copy
    Curses_error(const char* curses_function_name, const Error* base_error = 0);
    virtual Curses_error* clone() const { return new Curses_error(*this); }
    // other
    virtual std::string error_class() const { return "Curses_error"; }
  protected:
    // invariant check
    bool mf_invariant(bool check_base_class = true) const;
  private:
    typedef std::map<std::string, std::string> Fn_description_map;
    static Fn_description_map m_fn_description_map;
    static std::string mf_fn_description(const std::string& fn_name);
    // prevent compiler from generating
    Curses_error operator=(const Curses_error& e);
  };
}

#endif // CURSES_ERROR_HPP_
