// AAFW_error.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

// Async_audio_file_writer Error

#ifndef AAFW_ERROR_HPP_
#define AAFW_ERROR_HPP_

#include "Error.hpp"
#include <string>

namespace Roan_trail
{
  namespace Recorder
  {
    class AAFW_error : public Error
    {
    public:
      // constructor/destructor/copy
      AAFW_error(const char* file,
                 const char* function,
                 int line,
                 int code,
                 const Error* base_error = 0);
      AAFW_error(const char* file,
                 const char* function,
                 int line,
                 int code,
                 const std::string& diagnostic,
                 const Error* base_error = 0);
      virtual AAFW_error* clone() const { return new AAFW_error(*this); }
      // other
      virtual std::string error_class() const { return "AAFW_error"; }
      // error codes
      static const int none                      =  0; // code for none should always be 0
      static const int general                   =  1; // code for general error should always be 1
      static const int start                     =  2;
      static const int pause                     =  3;
      static const int write                     =  4;
      static const int write_overflow            =  5;
      static const int write_loop                =  6;
      static const int write_loop_corrupt_buffer =  7;
      static const int write_loop_general        =  8;
      static const int create_temp_file          =  9;
      static const int open_output_file          = 10;
      static const int overwrite                 = 11;
      static const int stop                      = 12;
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      // prevent compiler from generating
      AAFW_error operator=(const AAFW_error& e);
    };

#define start_AAFW_error_block()                              \
    Roan_trail::Recorder::AAFW_error* handler_AAFW_error = 0; \
    {

#define end_AAFW_error_block()                  \
    }

#define on_AAFW_error(cond, error)              \
    if (cond)                                   \
    {                                           \
      handler_AAFW_error = (error);             \
      goto error_handler;                       \
    }

#define on_AAFW_error_with_label(cond, label, error)    \
    if (cond)                                           \
    {                                                   \
      handler_AAFW_error = (error);                     \
      goto label;                                       \
    }
  }
}

#endif // AAFW_ERROR_HPP_
