// AAFW_error.cpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#include "AAFW_error.hpp"
#include "../common.hpp"
#include <string>

using std::string;
using namespace Roan_trail::Recorder;

//
// Constructor/destructor/copy
//

AAFW_error::AAFW_error(const char* file,
                       const char* function,
                       int line,
                       int code,
                       const Error* base_error)
  : Error(file,
          function,
          line,
          code,
          base_error)
{
  postcondition(mf_invariant(false));
}

AAFW_error::AAFW_error(const char* file,
                       const char* function,
                       int line,
                       int code,
                       const string& diagnostic,
                       const Error* base_error)
  : Error(file,
          function,
          line,
          code,
          base_error)
{
  if ("" != diagnostic)
  {
    error_dictionary()[Error::diagnostic_error_key] = diagnostic;
  }

  postcondition(mf_invariant(false));
}

//
// Error codes
//

const int AAFW_error::none;
const int AAFW_error::general;
const int AAFW_error::start;
const int AAFW_error::pause;
const int AAFW_error::write;
const int AAFW_error::write_overflow;
const int AAFW_error::write_loop;
const int AAFW_error::write_loop_corrupt_buffer;
const int AAFW_error::write_loop_general;
const int AAFW_error::create_temp_file;
const int AAFW_error::open_output_file;
const int AAFW_error::overwrite;
const int AAFW_error::stop;

//
// Protected member functions
//

bool AAFW_error::mf_invariant(bool check_base_class) const
{
  bool return_value = false;

  if ((code() < AAFW_error::none) || (code() > AAFW_error::stop))
  {
    goto exit_point;
  }
  else
  {
    return_value = (!check_base_class || Error::mf_invariant(check_base_class));
  }

 exit_point:

  return return_value;
}
