// Movie_types.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef MOVIE_TYPES_HPP_
#define MOVIE_TYPES_HPP_

#include "common.hpp"

namespace Roan_trail
{
  namespace Builder
  {
    typedef int Video_codec_type;
    typedef int Frame_rate_type;
    typedef int Frame_size_type;
    class Frame_rate
    {
    public:
      Frame_rate(int time_scale, int frame_length)
        : m_time_scale(time_scale), m_frame_length(frame_length)
      { precondition(((time_scale > 0) && (frame_length > 0))); }
      Frame_rate() : m_time_scale(3000), m_frame_length(100) {}
      int time_scale() const { return m_time_scale; }
      int frame_length() const { return m_frame_length; }
    private:
      int m_time_scale;
      int m_frame_length;
    };
  }
}

#endif // MOVIE_TYPES_HPP_
