// Movie_builder_model.hpp
//
// Copyright 2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef MOVIE_BUILDER_MODEL_HPP_
#define MOVIE_BUILDER_MODEL_HPP_

#include "../base/common.hpp"
#include <string>
#include <vector>

namespace xmlpp
{
  class Node;
}

namespace Roan_trail
{
  class Error_param;

  namespace Recorder
  {
    class Segment;
  }

  namespace Builder
  {
    class Movie_builder_model
    {
    public:
      Movie_builder_model();
      virtual ~Movie_builder_model() {}
      const std::string& audio_recording_path() const { return m_audio_recording_path; }
      Long_int audio_recording_frame_rate() const { return m_audio_recording_frame_rate; }
      const std::vector<Roan_trail::Recorder::Segment>& segments() const { return m_segments; }
      // load
      bool load_from_XML(const std::string& file_path,
                         const xmlpp::Node* XML_node,
                         Error_param& return_error);
    protected:
      std::string m_audio_recording_path;
      Long_int m_audio_recording_frame_rate;
      std::vector<Roan_trail::Recorder::Segment> m_segments;
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      // prevent compiler from generating
      Movie_builder_model(const Movie_builder_model& m);
      Movie_builder_model& operator=(const Movie_builder_model& m);
    };
  }
}

#endif // MOVIE_BUILDER_MODEL_HPP_

