// Kinetophone_narrator_view.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef KINETOPHONE_NARRATOR_VIEW_HPP_
#define KINETOPHONE_NARRATOR_VIEW_HPP_

#include "../base/common.hpp"
#include <string>
#include <vector>
#include <utility>
#include <sigc++/sigc++.h>

namespace Gtk
{
  class ToggleButton;
}

using std::string;
using std::vector;
using std::pair;
using sigc::connection;
using Gtk::ToggleButton;

namespace Roan_trail
{
  class Error;
  class Error_param;

  namespace Kinetophone
  {
    class Kinetophone_narrator_model;
    class Kinetophone_narrator_config;
    class Kinetophone_narrator_window;

    class Kinetophone_narrator_view
    {
    public:
      // constructor/destructor
      Kinetophone_narrator_view(const Kinetophone_narrator_model& model,
                                const Kinetophone_narrator_config& config);
      virtual ~Kinetophone_narrator_view();
      // accessors
      const Kinetophone_narrator_config& config() const { return m_config; }
      Kinetophone_narrator_window& narrator_window() const { return *m_main_window; }
      //   signals
      sigc::signal<void> signal_retake() { return m_retake_signal; }
      sigc::signal<void> signal_previous() { return m_previous_signal; }
      sigc::signal<void, int> signal_slide() { return m_slide_signal; }
      sigc::signal<void> signal_next() { return m_next_signal; }
      sigc::signal<void, int> signal_thumbnail_choose() { return m_thumbnail_choose_signal; }
      sigc::signal<void> signal_mute() { return m_mute_signal; }
      sigc::signal<void> signal_pause() { return m_pause_signal; }
      sigc::signal<void> signal_record() { return m_record_signal; }
      sigc::signal<void> signal_toggle_metering() { return m_toggle_metering_signal; }
      sigc::signal<void> signal_notes_changed() { return m_notes_changed_signal; }
      sigc::signal<void, const string&> signal_notes_editing_done() { return m_notes_editing_done_signal; }
      sigc::signal<void, string> signal_export_session() { return m_export_session_signal; }
      sigc::signal<void> signal_quit() { return m_quit_signal; }
      // updates
      void model_slides_will_update();
      void model_recorder_will_update();
      void model_slides_updated();
      void model_recorder_updated();
      void update_levels();
      void update_available_space();
      void update_statusbar();
      void update_time(bool is_flashing = false);
      // commands
      void setup() { m_setup = true; }
      void toggle_metering();
      void show_session_info(const string& message);
      int show_error(const Error& error, bool is_warning);
      bool ask_overwrite_recording();
      static void output_console(const string& message);
      static void output_error(const string& message);
      static bool list_devices(Error_param& return_error);
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      const Kinetophone_narrator_model& m_model;
      const Kinetophone_narrator_config& m_config;
      Kinetophone_narrator_window* m_main_window;
      bool m_setup;
      vector<double> m_levels;
      string m_file_size;
      string m_audio_info;
      string m_overflow_count;
      // signals
      sigc::signal<void> m_retake_signal;
      sigc::signal<void> m_previous_signal;
      sigc::signal<void, int> m_slide_signal;
      sigc::signal<void> m_next_signal;
      sigc::signal<void, int> m_thumbnail_choose_signal;
      sigc::signal<void> m_mute_signal;
      sigc::signal<void> m_pause_signal;
      sigc::signal<void> m_record_signal;
      sigc::signal<void> m_toggle_metering_signal;
      sigc::signal<void> m_notes_changed_signal;
      sigc::signal<void, const string &> m_notes_editing_done_signal;
      sigc::signal<void, string> m_export_session_signal;
      sigc::signal<void> m_quit_signal;
      // connections
      connection m_pause_toggle_connection;
      connection m_slide_connection;
      connection m_slide_notes_connection;
      vector<pair<ToggleButton*, connection> > m_thumbnail_browser_toggle;
      //
      void mf_format_audio_info_string();
      string& mf_update_file_size();
      string& mf_update_overflow_count();
      void mf_setup_slide_combo();
      void mf_connect_signals();
      void mf_setup_thumbnail_browser();
      // slots (customized)
      void mf_slide();
      void mf_mute();
      void mf_notes_changed();
      void mf_notes_editing_done();
      void mf_export_session();
      bool mf_delete_main_window(GdkEventAny* event);
      void mf_quit();
      void mf_cut();
      void mf_copy();
      void mf_paste();
      void mf_about();
      // helpers
      bool mf_verify_quit();
      // prevent compiler from generating
      Kinetophone_narrator_view(const Kinetophone_narrator_view& narrator_view);
      Kinetophone_narrator_view& operator=(const Kinetophone_narrator_view& narrator_view);
    };
  }
}

#endif // KINETOPHONE_NARRATOR_VIEW_HPP_
